dofile("config.lua")

cache=CImage()
image=CImage()

function processPage(outdir, pageNo, numRects)
	local width=device_width
	local height=device_height
	local max_rect=-1
	local max_rect_area=0
	local max_rect_width=0
	local rect_width=0
	local rect_height=0
	local temp=0
	local temp1=0
	local temp2=0
	for rectNo=0, numRects-1 do
		--win:setStatus("checking"..pageNo.."_"..rectNo)
		rect_width=win:getDPI_width(pageNo, rectNo, width)
		temp1=width/rect_width
		rect_height=win:getDPI_height(pageNo, rectNo, height)
		temp2=height/rect_height
		temp=temp1*temp2
		--win:setStatus("area"..temp)
		if temp > max_rect_area then
			max_rect_area=temp
			max_rect=rectNo
			max_rect_width=rect_width
		end
	end

	for rectNo=0, numRects-1 do
		--win:setStatus("checking"..pageNo.."_"..rectNo)
		rect_width=win:getDPI_width(pageNo, rectNo, width)
		temp1=width/rect_width
		rect_height=win:getDPI_height(pageNo, rectNo, height)
		temp2=height/rect_height
		if ( temp2/temp1 < 5) then
			area=temp1*temp2

			win:setStatus("rect"..pageNo.."_"..rectNo)
			crop_width=width*math.sqrt(math.sqrt(max_rect_width/rect_width))
			if crop_width > width then
				crop_width = width
			end
			win:getRectImage_width(pageNo, rectNo, crop_width, image)

--			if not (pageNo == 27 or pageNo == 163) then
--				postprocessImage(image)
--			end

			if cache:GetHeight()==0 then
				cache:CopyFrom(image)
			else
				cache:concatVertical(cache, image)
			end
		end
	end

	if cache:GetHeight() < height then
		return 1
	end

	local subpage=0
	local curY=0
	while cache:GetHeight() >= height do
		curY=0
		image:crop(cache, 0, curY, cache:GetWidth(), curY+height)
		postprocessImage(image)
		outputImage(image, outdir, pageNo, subpage)
		cache:crop(cache, 0, curY+height-scroll_overlap_pixels, cache:GetWidth(), cache:GetHeight())
		subpage=subpage+1
	end
	return 1
end


function processAllPages(outdir)
	initializeOutput(outdir)
	for pageNo=0, win:getNumPages()-1 do
		win:setCurPage(pageNo)
		if processPage(outdir, pageNo, win:getNumRects())==0 then
			return 0
		end
		pageNext=pageNo+1
	end

	if cache:GetHeight() > 0 then
		outputImage(cache, outdir, pageNext, 0)
	end
	finalizeOutput(outdir)
	return 1
end
